import 'dart:convert';
import 'package:play_lab/data/model/global/global_meassage.dart';
import 'package:play_lab/data/model/global/global_user_model.dart';

LiveTvChatResponseModel liveTvChatResponseModelFromJson(String str) => LiveTvChatResponseModel.fromJson(json.decode(str));

String liveTvChatResponseModelToJson(LiveTvChatResponseModel data) => json.encode(data.toJson());

class LiveTvChatResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  LiveTvChatResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory LiveTvChatResponseModel.fromJson(Map<String, dynamic> json) => LiveTvChatResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<LiveChatCommentModel>? comments;

  Data({
    this.comments,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        comments: json["comments"] == null ? [] : List<LiveChatCommentModel>.from(json["comments"]!.map((x) => LiveChatCommentModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "comments": comments == null ? [] : List<dynamic>.from(comments!.map((x) => x.toJson())),
      };
}

class LiveChatCommentModel {
  String? id;
  String? userId;
  String? liveTelevisionId;
  String? gameId;
  String? comment;
  String? createdAt;
  String? updatedAt;
  GlobalUser? user;

  LiveChatCommentModel({
    this.id,
    this.userId,
    this.liveTelevisionId,
    this.gameId,
    this.comment,
    this.createdAt,
    this.updatedAt,
    this.user,
  });

  factory LiveChatCommentModel.fromJson(Map<String, dynamic> json) => LiveChatCommentModel(
        id: json["id"]?.toString(),
        userId: json["user_id"]?.toString(),
        liveTelevisionId: json["live_television_id"]?.toString(),
        gameId: json["game_id"]?.toString(),
        comment: json["comment"],
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        user: json["user"] == null ? null : GlobalUser.fromJson(json["user"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "live_television_id": liveTelevisionId,
        "game_id": gameId,
        "comment": comment,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "user": user?.toJson(),
      };
}
